import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_AddCanFilter"

    // unique for every action
    actionId: 0x1B
    actionName: QT_TRANSLATE_NOOP("AddCanFilter", "AddCanFilter")
    actionTitle: qsTr("Filter:\n\"\"")
    actionToolTip: qsTr("Add Can Filter")

    parameterDialogSource: 'AddCanFilterDialog.qml'

    parametersModel: ListModel {
        id: core_model

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("AddCanFilter", "Identifier")
            paramType: "int" // Если выставить такой тип, то переменная будет отображаться в списке глобальных переменных.
            varCategory: ".*"
            varName: ""
            isEditable: true
            value: 0
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("AddCanFilter", "Mask")
            paramType: "int" // Если выставить такой тип, то переменная будет отображаться в списке глобальных переменных.
            varCategory: ".*"
            varName: ""
            isEditable: true
            value: 0
        }

        Component.onCompleted: {
            parametersModel.append(
                        {
                            "paramName": qsTranslate("AddCanFilter", "Identifier Bits\n Length"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": "",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : qsTranslate("AddCanFilter", "11-bits (CAN 2.0 A)"),
                                    "desc"    : qsTranslate("AddCanFilter", "11-bits "),
                                    "value"   : 0 // Standard Value
                                },				
				{
                                    "varName" : qsTranslate("AddCanFilter", "29-bits (CAN 2.0 B)"),
                                    "desc"    : qsTranslate("AddCanFilter", "29-bits"),
                                    "value"   : 1 // Extended Value
                                }]
                        });
        }

   }

    function setTitle() {
        var data_1 = parametersModel.get(0).varName
        var data_2 = parametersModel.get(1).varName
        var data_3 = parametersModel.get(2).varName

        if (data_1.length === 0)
            data_1 = qsTr("???")

        if (data_2.length === 0)
            data_2 = qsTr("???")

        if (data_3.length === 0)
            data_3 = qsTr("???")

        actionTitle = qsTr("Identifier: %1\n Mask: %2\n Identifier Bits Length: %3").arg(data_1).arg(data_2).arg(data_3)
    }
}
