import QtQuick 2.2
import QtQuick.Dialogs 1.1

Item {  // is situated outside of parent
    id: buttonsItem
    objectName: "buttonItem"

    property Item actionItem    // must be set after item creation
    property alias destroyTimer: destroyTimer
    
    function dump() {
        console.debug("---- dump:", objectName, actionItem);
    }

    function destroyItem() {
        actionItem.buttonsItem = null;
        itemIsAboutToDestroy(buttonsItem);
        destroy();
    }

    width: buttonColumn.width + buttonColumn.spacing * 2
    height: buttonColumn.height + buttonColumn.spacing * 2

    Component.onCompleted: {
        console.debug(objectName, "completed")
    }
    Component.onDestruction: {
        console.debug(objectName, "destructed")
    }

    onActionItemChanged: {
        if (actionItem === null)
            return;

        // set buttons visibility according to action
        editImage.visible = Qt.binding( function() {
            return actionItem.parametersModel
                    ? actionItem.parametersModel.count : false
        })
        chainColorImage.visible = Qt.binding( function() {
            return !(actionItem.actionType === "action")    // only when action is event
        })
    }

    Timer {
        id: destroyTimer

        interval: buttonsTimerInterval
        onTriggered: destroyItem()
    }

    Rectangle {
        id: buttonRect
        objectName: "buttonRect"
        
        anchors.fill: parent
        radius: width/2
        color: "gray"
        opacity: 0.5
    }
    
    MouseArea {
        id: buttonRectArea
        objectName: "buttonRectArea"
        
        anchors.fill: parent
        hoverEnabled: true
    
        onEntered: destroyTimer.stop()
        onExited: destroyTimer.start()

        Column {
            id: buttonColumn
            objectName: "buttonColumn"

            readonly property real buttonSize: Math.round(26 * kDPI)

            anchors.centerIn: parent
            spacing: Math.round(3 * kDPI)

            Image {
                id: deleteImage
                objectName: "deleteImage"
                width:  parent.buttonSize
                height: parent.buttonSize
                source: "../images/icon-trash.svg"
                sourceSize.width: Math.round(128* kDPI)
                sourceSize.height: Math.round(128 * kDPI)

                MouseArea {
                    id: deleteImageArea
                    objectName: "deleteImageArea"
                    anchors.fill: parent

                    onClicked: actionItem.destroyItem()
                }
            }
            Image {
                id: editImage
                objectName: "editImage"
                width:  parent.buttonSize
                height: parent.buttonSize
                source: "../images/icon-edit.svg"
                sourceSize.width: Math.round(128 * kDPI)
                sourceSize.height: Math.round(128 * kDPI)
                visible: false

                MouseArea {
                    id: editImageArea
                    objectName: "editImageArea"
                    anchors.fill: parent

                    onClicked: actionItem.showParametersDialog()
                }
            }
            Image {
                id: chainColorImage
                objectName: "chainColorImage"
                width:  parent.buttonSize
                height: parent.buttonSize
                source: "../images/icon-palette.svg"
                sourceSize.width: Math.round(128 * kDPI)
                sourceSize.height: Math.round(128 * kDPI)
                visible: false

                MouseArea {
                    id: chainColorArea
                    objectName: "chainColorArea"
                    anchors.fill: parent

                    onClicked: actionItem.showColorDialog()
                }
            }
        }
    }
}
