import QtQuick 2.0

Item {
    id: varNameDelegate
    objectName: "varNameDelegate"

    property alias text: actionItemText.text
    property alias font: actionItemText.font

    signal clicked(var clickedIndex, var clickedText)
    signal doubleClicked(var clickedIndex, var clickedText)

    height: Math.round(22 * kDPI)
    implicitWidth: parent.width
    anchors.horizontalCenter: parent.horizontalCenter

    // internal vars
    property var view: ListView.view
//    property var model: ListView.view.model

    Rectangle {
        id: decorator

        anchors.fill: parent
        border.color: colorScrollBorder
        color: varNameDelegate.ListView.isCurrentItem
               ? colorSelected : "white"
    }
    Text {
        id: actionItemText

        anchors.left: parent.left
        anchors.leftMargin: diagramContainer.diagramField.linesGridSize
        anchors.right: parent.right
        anchors.rightMargin: diagramContainer.diagramField.linesGridSize
        anchors.verticalCenter: parent.verticalCenter
        verticalAlignment: Text.AlignVCenter
        elide: Text.ElideRight
        font.family: "Verdana"
        font.pointSize: 8
        font.letterSpacing: 0.5
        color: colorTextPanel
        text: model.varName
    }
    MouseArea {
        id: mouseArea

        anchors.fill: parent
        hoverEnabled: true

        onClicked: {
            console.debug(parent.objectName, "onClicked:",
                          index, actionItemText.text);
            view.currentIndex = index;
            varNameDelegate.clicked(index, actionItemText.text);
        }
        onDoubleClicked: {
            console.debug(parent.objectName, "onDoubleClicked:",
                          index, actionItemText.text);
            varNameDelegate.doubleClicked(index, actionItemText.text);
        }
    }
}
