// Вспомогательные Функции для расчета фильтров.

function linearInt(value, x1, y1, x2, y2){
    var a = (y2 - y1)/(x2 - x1);
    var b = y2- x2*a;

    return Math.round(value*a + b);
}

function applyTarTableFilter(value, table){
    if (table.length === 2) {
        var x1 = table[0];
        var y1 = table[1];
        // просто линейная функция проходящая через ноль
        return value*(y1/x1) + 0.5;
    }

    var i;
    for (i = 2; i < table.length - 2; i += 2) {
        // определим x2
        var x2 = table[i];
        // если value < x2 тогда применяем  линию на участке x1,y1,x2,y2 и т.д.
        if (value <= x2) {
            var x1 = table[i - 2];
            var y1 = table[i - 1];
            var y2 = table[i + 1];
            return linearInt(value, x1, y1, x2, y2);
        }
    }
    // не зависимо от того попали в послений участок - делаем вычисления на его основе.
    var x2 = table[i];
    var x1 = table[i - 2];
    var y1 = table[i - 1];
    var y2 = table[i + 1];
    console.log(table);
    return linearInt(value, x1, y1, x2, y2);
}


var te =  // Коэффициент объёмного расширения, взято из ГОСТ 8.595-2004. Масса нефти и нефтепродуктов
     [// плотность, коэффициент
           [690, 0.00130] ,
           [700, 0.00126] ,
           [710, 0.00123] ,
           [720, 0.00119] ,
           [730, 0.00116] ,
           [740, 0.00113] ,
           [750, 0.00109] ,
           [760, 0.00106] ,
           [770, 0.00103] ,
           [780, 0.00100] ,
           [790, 0.00097] ,
           [800, 0.00094] ,
           [810, 0.00092] ,
           [820, 0.00089] ,
           [830, 0.00086] ,
           [840, 0.00084] ,
           [850, 0.00081] ,
           [860, 0.00079] ,
           [870, 0.00076] ,
           [880, 0.00074] ,
           [890, 0.00072] ,
           [900, 0.00070] ,
           [910, 0.00067] ,
           [920, 0.00065] ,
           [930, 0.00063] ,
           [940, 0.00061] ,
           [950, 0.00059] ,
           [960, 0.00057] ,
           [970, 0.00055] ,
           [980, 0.00053] ,
           [990, 0.00052]
       ];

function koeffTE(ro){
    var res = te[0][1];
    te.forEach(function(element, i, arr) {
        if (ro < element[0]){
            return res;
        }
        res = element[1];
      });
    return res;
}

function findSelectedParameterValue(item){
    var var_name = item.varName;
    var list = item.paramList;

    for (var i =0; i< list.count; ++i){
        console.log("val:", list.get(i), "var_name:", list.get(i).varName);
        if (var_name === list.get(i).varName) {
            return parseInt(list.get(i).value);
        }
    }
    return 0; // не обязательно. в принципе пока у нас всегда будет параетр заполнен
}

// Определение среднего по предыдущему значению. (приблизительный расчет)
function average(cur_value, filtered_value, window_len){
  // Считаем разницу между значениями, делим на длину фильтра
  var delta = (cur_value - filtered_value) / window_len;
  // если четно хз ка такое может получиться, только есил окно ооочень большое
  if (delta === 0 && cur_value !== filtered_value){
    delta++;
  }
  return filtered_value + delta;
}

// Функции математики
function mathOperation(id, left, right){
    switch(id) {
      case 0: //  "*"
          return left * right;
      case 1: //  "/"
          return left / right;
      case 2: //  "%"
          return left % right;
      case 3: //  "+"
          return left + right;
      case 4: //  "-"
          return left - right;
      case 5: //  "<<"
          return left << right;
      case 6: //  ">>"
          return left >> right;
      case 7: //  "&"
          return left & right;
      case 8: //  "^"
          return left ^ right;
      case 9: //  "|"
          return left | right;
      case 10: //  "&&"
          return left && right;
      case 11: //  "||"
          return left || right;
    }
}












