import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_EnableWiFiUnit"

    // unique for every action
    actionId: 0x19
    actionName: QT_TRANSLATE_NOOP("EnableWiFiUnit", "EnableWiFiUnit")
    actionTitle: qsTr("WiFi unit:\nEnable = ???")
    actionToolTip: qsTr("Enable WiFi unit")

    parametersModel: ListModel {

        onDataChanged: { setTitle() }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("EnableWiFiUnit", "Enabled")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var enableStr = parametersModel.get(0).varName;

        if (enableStr === "0")
            actionTitle = qsTr("Disable WiFi unit");
        else if (enableStr === "1")
            actionTitle = qsTr("Enable WiFi unit");
        else
            actionTitle = qsTr("WiFi unit:\nEnable = %1").arg(enableStr);
    }
}
