import QtQuick 2.2
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.2
import QtQuick.Layouts 1.1

Rectangle {
    id: leftPanel
    objectName: "leftPanel"

    color: colorWhitespace

    property ListModel panel_model: ListModel{}

    Component {
        id: events_model
        ActionsToolBar {
            id: eventToolBar
            objectName: "eventToolBar"

            width: view.width
            actionTitle: qsTr("Events")
            actionModel: EventsModel {}
        }
    }

    Component {
        id: actions_model
        ActionsToolBar {
            id: actionsToolBar
            objectName: "actionsToolBar"

            width: view.width
            actionTitle: qsTr("Actions")
            actionModel: ActionsModel {}
        }
    }

    Component {
        id: vars_model
        VarsPanel {
            id: globalVarsRect
            objectName: "globalVarsRect"

            width: view.width
            panelTitle: qsTr("Global vars")
            varCategory: categoryGlobal
        }
    }

    Component {
        id: filters_model
        ActionsToolBar {
            id: filterToolBar
            objectName: "filterToolBar"

            width: view.width
            actionTitle: qsTr("Filters")
            actionModel: FiltersModel {}
        }
    }

    Component {
        id: parameters_model
        ActionsToolBar {
            id: parameterToolBar
            objectName: "parameterToolBar"

            width: view.width
            actionTitle: qsTr("Parameters")
            actionModel: ParametersModel {}
        }
    }

    ScrollView {
        id: view
        objectName: "view"

        anchors.fill: parent
        flickableItem.interactive: leftPanelInteractive
        flickableItem.flickableDirection: Flickable.VerticalFlick
        style: MyScrollViewStyle {}

        ListView{
            id: lv
            model: panel_model
            delegate: Loader {
                property int type: model.type
                width: view.width
                sourceComponent: {
                    switch(type) {
                    case 1:
                        return events_model;
                    case 2:
                        return actions_model;
                    case 3:
                        return vars_model;
                    case 4:
                        return filters_model;
                    case 5:
                        return parameters_model;
                    }
                }
            }
        }
    }
}
