import QtQuick 2.2
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0


Rectangle {
    id: canParserDialog
    objectName: "canParserDialog"

    property string standart_var_name: qsTranslate("ParseCanMessage", "Value");

    property var diagramItem: null
    property var parametersModel: null

    property string scriptName

    property int paramaterItemHeight: Math.round(20 * kDPI)
    property real centerPointX: 0.0
    property real centerPointY: 0.0
    property real scaleFactorX: 0.0
    property real scaleFactorY: 0.0
    property string compileResult

    property int size_offset: 20
    property int pos_offset: 10

    property int index_row_height: 20*2
    property int index_var_width: 200

    property int header_body_height: 40
    property int header_footer_height: 40
    property int title_height: 20
    property int header_height: title_height + header_body_height + header_footer_height;

    property int footer_height: 40
    property int start_width: 7

    // Добавим свойство которое хранит индекс выбранного диалога переменной.
    property int current_variable_index: 0
    property int row_count: 1

    width: Math.round(720 * kDPI)
    height: header_height + index_row_height*row_count + footer_height;//Math.round(600 * kDPI)
    radius: Math.round(10 * kDPI)
    z: zParameterDialog
    color: colorDialogBackground
    border.width: 1
    border.color: colorDialogBorder
    visible: false

    function changeHeight(){
        canParserDialog.height = header_height + index_row_height*row_count + footer_height;
    }

    function dump() {
        console.debug("---- canParserDialog dump start:", objectName);
        var i;
        console.debug("parametersModel:", parametersModel);
        for (i = 0; i < parametersModel.count; ++i)
            console.debug(parametersModel.get(i).paramName,
                          parametersModel.get(i).paramType,
                          parametersModel.get(i).varName);
        console.debug("---- canParserDialog dump finish:", objectName);
    }

    function showItem(item) {
        diagramItem = item

        canParserDialog.parametersModel = item.parametersModel;

        scriptName = canParserDialog.parametersModel.get(parametersModel.paramIndex).varName;

        var items_count = canParserDialog.parametersModel.count;
        row_count = (items_count-2) / 4; // 2 переменных данных, и 4 элемента на 1 строку
        changeHeight();

        console.debug(canParserDialog.parametersModel.get(parametersModel.paramIndex).varName)
        dump();

        // center dialog to item
        var itemCenter = diagramContainer.mapFromItem(item, item.width/2, item.height/2);
        centerPointX = itemCenter.x;
        centerPointY = itemCenter.y;
        // set size to item and show,...
        scaleFactorX = diagramContainer.diagramField.itemWidth / width;
        scaleFactorY = diagramContainer.diagramField.itemHeight / height;
        visible = true;
        // ...than animate to normal size
        centerPointX = parent.width/2
        centerPointY = parent.height/2
        scaleFactorX = 1.0;
        scaleFactorY = 1.0;
    }

    function accept() {
        console.debug(objectName, arguments.callee.name);
        visible = false;
    }
    function selectionChanged(item, mouseEvent, itemWasSelected) {
        console.debug(objectName, "selectionChanged()", item)
        if ((visible === false) || (item === canParserDialog))
            return;

        accept();
        dump();
    }

    function setIndex(_index){
        canParserDialog.current_variable_index = _index;
        console.debug(objectName, "new index setted")
    }


    MouseArea {
        anchors.fill: parent
        drag.target: parent
        acceptedButtons: (Qt.LeftButton | Qt.RightButton)
    }


    // Переелаем текущий вид. Он будет как
    /// Header, body, bottom

    // Содержит заголовок, кнопку закрыть, переменные данных, а так же кнопку добавить данные
    Rectangle{
        id: header
        color: "transparent"

        anchors.top: parent.top
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.topMargin: canParserDialog.pos_offset
        anchors.leftMargin: canParserDialog.pos_offset
        anchors.rightMargin: canParserDialog.pos_offset

        width: parent.width
        height: parent.header_height

        border.width: regularThickness
        // Содержит заголовок, кнопку закрыть
        Rectangle{
            id: title
            anchors.top: parent.top
            anchors.left: parent.left
            width: parent.width
            height: canParserDialog.title_height

            Text{
                font.bold: true
                text: qsTr("CAN Parser")
            }
            Rectangle {
                id: closeRect
                anchors.right: parent.right;
                anchors.top: parent.top;
                anchors.topMargin: Math.round(-6 * kDPI)
                anchors.rightMargin: Math.round(-6 * kDPI)
                width: Math.round(18 * kDPI)
                height: Math.round(18 * kDPI)

                Image {
                    id: closeImage

                    source: "images/icon_close.svg"
                    sourceSize.width: Math.round(18 * kDPI)
                    sourceSize.height: Math.round(18 * kDPI)
                    smooth: false

                    MouseArea {
                        id: closeRectArea
                        objectName: "closeRectArea"
                        anchors.fill: parent
                        onClicked: {
                            console.debug("canparserDialog. Close clicked")
                            accept()
                        }
                    }
                }
            }
        }
        // Содержит переменные данных
        Rectangle{
            id: header_body
            width: parent.width
            height: canParserDialog.header_body_height

            Row {
                id: data_1
                anchors.left: parent.left
                anchors.top: parent.top
                height: header_body_height/2
                Text {
                    text: qsTranslate("ParseCanMessage", "Data1: ")
                }
                VarNameItem {   // for others types
                    id: data_item_1
                    width: 100
                    height: parent.height
                    paramModel: parametersModel
                    paramIndex: 0
                }
            }
            Row {
                id: data_2
                anchors.top: data_1.bottom
                height: header_body_height/2
                Text {
                    text: qsTranslate("ParseCanMessage", "Data2: ")
                }
                VarNameItem {   // for others types
                    id: data_item_2
                    width: 100
                    height: parent.height
                    paramModel: parametersModel
                    paramIndex: 1
                }
            }

            anchors.top: title.bottom
        }
        // Содержит  кнопку добавить данные
        Rectangle{
            id: header_footer
            width: parent.width
            height: canParserDialog.header_footer_height
            anchors.top: header_body.bottom

            ListModel {
                id: bit_indexes
                ListElement{
                    text:"8"
                }
                ListElement{
                    text:"16"
                }
                ListElement{
                    text:"24"
                }
                ListElement{
                    text:"32"
                }
                ListElement{
                    text:"40"
                }
                ListElement{
                    text:"48"
                }
                ListElement{
                    text:"56"
                }
            }

            Rectangle {
                id: bytes_header

                anchors.top: parent.top

                width: parent.width
                height: parent.height/2


                Text {
                    id: bytes_text
                    text: qsTr("bytes:")

                    anchors.top: parent.top
                    anchors.right: byt_text_0.left
                    anchors.rightMargin: pos_offset + start_width*4;

                }

                Text {
                    id: byt_text_0
                    height: parent.height
                    width: start_width
                    text: "0"
                    color: "gray"

                    anchors.top: parent.top
                    anchors.topMargin: 2
                    anchors.left: parent.left
                    anchors.leftMargin: canParserDialog.index_var_width + start_width*4
                }

                Repeater {
                    model: bit_indexes
                    Text {
                        property int val: (model.index+1)
                        height: bytes_header.height
                        width: start_width
                        text: val.toString();
                        color: "gray"

                        anchors.top: bytes_header.top
                        anchors.topMargin: 2
                        anchors.left: byt_text_0.left
                        anchors.leftMargin: start_width*(9*val)
                    }
                }
            }

            Rectangle {
                id: bits_header
                //border.width: regularThickness
                anchors.top: bytes_header.bottom

                width: parent.width
                height: parent.height/2

                Text {
                    id: text_0
                    height: parent.height
                    width: start_width
                    text: "0"
                    color: "gray"

                    anchors.top: parent.top
                    anchors.left: parent.left
                    anchors.leftMargin: canParserDialog.index_var_width
                }

                Text {
                    id: bits_text
                    height: parent.height
                    text: qsTr("bits:")

                    anchors.top: parent.top
                    anchors.right: text_0.left
                    anchors.rightMargin: pos_offset
                }

                Repeater {
                    model: bit_indexes
                    Rectangle {
                        color: "transparent"
                        border.width: 1
                        border.color: "gray"

                        width: 9*start_width + 1
                        height: bits_header.height*2 - 2

                        anchors.left: text_0.left
                        anchors.leftMargin: start_width*(9*(model.index+1)) -1

                        anchors.top: bits_header.top
                        anchors.topMargin: bits_header.height*(-1)

                        Rectangle {
                            border.width: 1
                            border.color: "gray"
                            color: "transparent"

                            width: parent.width
                            height: parent.height/2
                            anchors.top: parent.top
                        }

                    }
                }

                Repeater{
                    model: bit_indexes
                    Text {
                        height: bits_header.height
                        width: start_width
                        text: model.text
                        color: "gray"

                        anchors.top: bits_header.top
                        anchors.left: text_0.left
                        anchors.leftMargin: start_width*(9*(model.index+1))
                    }
                }

                Text {
                    id: text_63
                    height: parent.height
                    width: start_width
                    text: "63"
                    color: "gray"

                    anchors.top: parent.top
                    anchors.left: text_0.left
                    anchors.leftMargin: start_width*(9*8 - 2)
                }

                //
                Rectangle {
                    id: design_table_border
                    color: "transparent"
                    border.width: 1
                    border.color: "gray"

                    width: 9*start_width + 1
                    height: bits_header.height*2 - 2

                    anchors.left: text_0.left
                    anchors.leftMargin: -1

                    anchors.top: bits_header.top
                    anchors.topMargin: bits_header.height*(-1)

                    Rectangle {
                        border.width: 1
                        border.color: "gray"
                        color: "transparent"

                        width: parent.width
                        height: parent.height/2
                        anchors.top: parent.top
                    }
                }
            }

        }
    }


    ListView{
        id: index_view

        model: parametersModel
        anchors.top: header.bottom
        height: canParserDialog.height - parent.header_height - parent.footer_height

        delegate: Row {
            height: model.isVisible ? canParserDialog.index_row_height : 0
            visible: model.isVisible ? true : false

            property ListModel bitsData: ListModel {
                id: bit_vals_model

                /* Пример элемента
                ListElement {
                    idx: 0
                    value: 0/1
                    left_idx: 0/1
                    right_idx: 0/1
                }
                */

                Component.onCompleted: generateBitsData();
                function generateBitsData(){
                    if (!model.isVisible) {
                        return;
                    }

                    for (var i = 0; i < 64; ++i) {
                        var idx_left = 0;
                        var idx_right = 0;
                        var idx = /*63-*/i;

                        // Выделим первый байт
                        if (i === 0) {
                            idx_left = 1;
                        }
                        if (i === 7) {
                            idx_right = 1;
                        }

                        // Сделать проверку данных по индексу модели
                        // сначало проверить отображается она или нет, чтобы не сыпались ошибки
                        if (model.isVisible) {
                            // Теперь проверим выбранный левый индекс
                            if (parametersModel.get(model.index + 1).varName === "%1".arg(idx)) {
                                idx_left = 1;
                                console.debug("set left idx, bit: ", i);
                            }
                            if (parametersModel.get(model.index + 2).varName === "%1".arg(idx)) {
                                idx_right = 1;
                                console.debug("set right idx, bit: ", i);
                            }
                        }

                        bit_vals_model.append({
                                              idx: idx,
                                              value:i%2,
                                              left_idx: idx_left,
                                              right_idx: idx_right
                                          });

                    }
                }
                onDataChanged: {
                    // Ищем изменившийся индекс и записываем его в модеь данных
                    // но сначалаопределяем это индекс левый или правый.
                    // при этом нужно не забыть перевернуть индексы, хотя можно просто добавить такое свойство.
                    for (var i= 0; i < bit_vals_model.count; ++i) {
                        if (1 === bit_vals_model.get(i).left_idx) {
                            parametersModel.setProperty(model.index + 1, "varName", bit_vals_model.get(i).idx); // left Старший бит
                            console.debug(parametersModel, "left changed", parametersModel.get(model.index+1).paramName);
                        }
                        if (1 === bit_vals_model.get(i).right_idx) {
                            parametersModel.setProperty(model.index + 2, "varName", bit_vals_model.get(i).idx); // right младший бит
                            console.debug(parametersModel, "right changed", parametersModel.get(model.index+2).paramName);
                        }
                    }

                }
            }

            // Создадим отдельную модель для отслеживания состояния endian чекбокса
            /// Тут идея в следующем:
            /// Мы подгружаем данные из глобальной модели.
            /// Если 1, то это big_endian и нужно поставить триггер в чекбокс
            /// Иначе little_endian и триггер в чекбоксе не нужен
            /// В нашу мини модель вставляем значение и отправляем запрос поставить соответствующий чекбокс
            /// В свою очередь чек бокс сможет сам тоже менять даные и на наше изменение тоже отреагирует.
            /// Это несколько избыточно, но как иначе сделать я не придумал.
            property ListModel endianData: ListModel {
                id: endian_data
                ListElement {
                    name: "is_little_endian"
                    value: 0; // Типа да
                }
                Component.onCompleted: {
                    if (model.isVisible) {
                        var value = parseInt(parametersModel.get(model.index + 3).varName, 10);
                        console.debug("************* setup endian: ", parametersModel.get(model.index + 3).varName);
                        endian_data.setProperty(0, "value", value);
                        bitsHandler.setup_checkbox = 0 === value ? false : true;
                    }
                }
                onDataChanged: {
                    var value = endian_data.get(0).value;
                    parametersModel.setProperty(model.index + 3, "varName", "%1".arg(value));
                    console.debug("************* change endian: ", value);
                }
            }

            Rectangle{ // ToDo Заменить на Row, точнее на listView который будет создавать данные
                id: body

                height: canParserDialog.index_row_height
                width: canParserDialog.width - 2*canParserDialog.pos_offset
                color: "transparent"
                anchors.leftMargin: canParserDialog.pos_offset
                anchors.rightMargin: canParserDialog.pos_offset

                // Содержит слоты для переменных куда будут складываться значения
                Rectangle{
                    id: body_left_column
                    width: canParserDialog.index_var_width;
                    height: parent.height/2
                    color: "transparent"
                    anchors.left: parent.left
                    anchors.leftMargin: canParserDialog.pos_offset

                    // Кнопка удаления данных
                    Rectangle {
                        id: del_row
                        anchors.left: parent.left
                        width: Math.round(18 * kDPI)
                        height: Math.round(18 * kDPI)

                        Image {
                            id: del_row_image

                            source: "images/icon_close.svg"
                            sourceSize.width: Math.round(18 * kDPI)
                            sourceSize.height: Math.round(18 * kDPI)
                            smooth: false

                            MouseArea {
                                id: del_row_image_area
                                objectName: "del_row_image_area"
                                anchors.fill: parent
                                onClicked: {
                                    parametersModel.removeElement(model.index);
                                    --row_count;
                                    changeHeight();
                                }
                            }
                        }
                    }


                    Text {
                        anchors.right: var_item.left
                        anchors.rightMargin: 10;
                        text: canParserDialog.standart_var_name
                    }

                    VarNameItem {   // for others types
                        id: var_item
                        width: 100
                        height: parent.height
                        anchors.right: parent.right
                        anchors.rightMargin: 10;
                        paramModel: parametersModel
                        paramIndex: model.index
                    }
                }
                // Содержит строки вывода битов и индексы.
                Rectangle{
                    id: body_right_column
                    height: parent.height
                    width: parent.width - body_left_column.width
                    color: "transparent"
                    anchors.left: body_left_column.right

                    BitsHandler {
                        id: bitsHandler
                        anchors.fill: parent
                        height: parent.height
                        width: parent.width

                        _bitsModel: bit_vals_model
                        endianModel: endian_data

                        selector_start_width: start_width
                    }
                }
              }
        }
    }
    // содержит кнопку добавления данных в body(addVariable)
    Rectangle{
        id: footer
        anchors.top: index_view.bottom
        anchors.left: parent.left
        anchors.leftMargin: pos_offset

        width: parent.width - 2*pos_offset
        height: parent.footer_height - pos_offset

        color: "transparent"

        Rectangle {
            id: addParamButton
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 4;
            height: parent.height - anchors.bottomMargin
            radius: height/3
            color: "transparent"
            border.width: 1
            border.color: colorBorder

            Text {
                anchors.centerIn: parent
                text: qsTr("Add Variable")
            }

            MouseArea {
                anchors.fill: parent

                onClicked: {
                    parametersModel.addParameter();
                    ++row_count;
                    changeHeight();
                }
            }
        }
    }

    transform: [
        Scale {
            origin.x: width/2
            origin.y: height/2
            xScale: scaleFactorX
            yScale: scaleFactorY
        },
        Translate {
            x: centerPointX - width/2
            y: centerPointY - height/2
        }
    ]
    Behavior on centerPointX {
        enabled: visible
        NumberAnimation {
            easing.type: Easing.Linear
        }
    }
    Behavior on centerPointY {
        enabled: visible
        NumberAnimation {
            easing.type: Easing.Linear
        }
    }

    Component.onCompleted: {
        diagramField.selectionChanged.connect(canParserDialog.selectionChanged)
        console.debug(objectName, "comleted")
    }
    Component.onDestruction: {
        diagramField.selectionChanged.disconnect(canParserDialog.selectionChanged)
        console.debug(objectName, "destructed")
    }
}
